-- -----------------------------------------------------------------
-- "Copyright (C) Altium Limited 2003"
-- -----------------------------------------------------------------
-- Component Name: 	IOBUF4S
-- Description: 	4-Bit Input/Output Buffer, Single Pin Version, Single Pin Version
-- Core Revision: 	1.00.00
-- -----------------------------------------------------------------
-- Modifications with respect to Version  : 
--
--
-- -----------------------------------------------------------------

library IEEE;
use IEEE.Std_Logic_1164.all;

entity IOBUF4S is
  port (
    T   : in    std_logic;
    I0  : in    std_logic;
    I1	: in 	std_logic;
    I2  : in 	std_logic;
    I3	: in 	std_logic;
    IO0 : inout std_logic;
    IO1 : inout std_logic;
    IO2	: inout std_logic;
    IO3	: inout std_logic;
    O0   : out  std_logic;
    O1	 : out  std_logic;
    O2	 : out  std_logic;
    O3	 : out  std_logic
    );
end IOBUF4S;

architecture STRUCTURE of IOBUF4S is

begin

  O0 <= IO0;
  O1 <= IO1;
  O2 <= IO2;
  O3 <= IO3;
  
  IO0 <= I0 when T = '0' else 'Z';
  IO1 <= I1 when T = '0' else 'Z';
  IO2 <= I2 when T = '0' else 'Z';
  IO3 <= I3 when T = '0' else 'Z';

  
end STRUCTURE;
